/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TooltipUtil {
    public static void addEffectsTooltip(List<EffectInstance> effects, List<ITextComponent> tooltip) {
        TooltipUtil.addEffectsTooltip(effects, tooltip, 1.0f);
    }

    public static void addEffectsTooltip(List<EffectInstance> effects, List<ITextComponent> tooltip, float durationMultiplier) {
        if (effects.isEmpty()) {
            IFormattableTextComponent noEffect = new TranslationTextComponent("effect.none").func_240699_a_(TextFormatting.GRAY);
            tooltip.add((ITextComponent)noEffect);
            return;
        }
        ArrayList attributeModifiers = Lists.newArrayList();
        for (EffectInstance effectInstance : effects) {
            TranslationTextComponent line = new TranslationTextComponent(effectInstance.func_76453_d());
            Effect effect = effectInstance.func_188419_a();
            Map map = effect.func_111186_k();
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), effect.func_111183_a(effectInstance.func_76458_c(), attributemodifier), attributemodifier.func_220375_c());
                    attributeModifiers.add(new Pair(entry.getKey(), (Object)attributemodifier1));
                }
            }
            if (effectInstance.func_76458_c() > 0) {
                line = new TranslationTextComponent("potion.withAmplifier", new Object[]{line, new TranslationTextComponent("potion.potency." + effectInstance.func_76458_c())});
            } else if (effectInstance.func_76459_b() > 20) {
                line = new TranslationTextComponent("potion.withDuration", new Object[]{line, EffectUtils.func_188410_a((EffectInstance)effectInstance, (float)durationMultiplier)});
            }
            tooltip.add((ITextComponent)line.func_240699_a_(effect.func_220303_e().func_220306_a()));
        }
        if (!attributeModifiers.isEmpty()) {
            tooltip.add(StringTextComponent.field_240750_d_);
            tooltip.add((ITextComponent)new TranslationTextComponent("potion.whenDrank").func_240699_a_(TextFormatting.DARK_PURPLE));
            for (Pair pair : attributeModifiers) {
                AttributeModifier modifier = (AttributeModifier)pair.getSecond();
                double amount = modifier.func_111164_d();
                if (amount == 0.0) continue;
                double d1 = modifier.func_111164_d();
                if (modifier.func_220375_c() == AttributeModifier.Operation.MULTIPLY_BASE || modifier.func_220375_c() == AttributeModifier.Operation.MULTIPLY_TOTAL) {
                    d1 *= 100.0;
                }
                if (amount < 0.0) {
                    d1 *= -1.0;
                }
                tooltip.add((ITextComponent)new TranslationTextComponent(String.format("attribute.modifier.%s.%i", amount > 0.0 ? "plus" : "take", modifier.func_220375_c().func_220371_a()), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(((Attribute)pair.getFirst()).func_233754_c_())}).func_240699_a_(amount > 0.0 ? TextFormatting.BLUE : TextFormatting.RED));
            }
        }
    }
}

